<?php     header( "Content-Type: application/xhtml+xml" ); ?>
<!DOCTYPE html PUBLIC
    "-//W3C//DTD XHTML 1.1 plus MathML 2.0 plus SVG 1.1//EN"
    "http://www.w3.org/2002/04/xhtml-math-svg/xhtml-math-svg.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" xmlns:svg="http://www.w3.org/2000/svg"
      xmlns:xlink="http://www.w3.org/1999/xlink" xml:lang="en">
<head>
<title>Wykres słupkowy - osadzony kod SVG</title>
<meta http-equiv="Content-Type" content="application/xhtml+xml; charset=UTF-8" />
<style type="text/css">
#legend
{
	color: #ffff00;
        position: absolute; top: 10; left: 10px; 
        font: italic small-caps 900 16px Georgia; 
        padding: 3px; background-color: #000; 
        border: 1px solid #fff;
}
</style>
  <script type="text/ecmascript">
    <![CDATA[

       // add mouse over event handler to each rectangle
       window.onload=function() {
         var rects = document.getElementsByTagNameNS('http://www.w3.org/2000/svg','rect');
         for (var i = 0; i < rects.length; i++)
            if (rects[i].id != 'banner')
               rects[i].onmouseover=showLegend;
       }

       // display legends
       function showLegend(evnt) {
         evnt = (evnt) ? evnt : ((window.event) ? window.event : "");
         var rectangle = (evnt.target) ? evnt.target : evnt.srcElement;
         var width = parseInt(document.getElementById('banner').getAttribute('width'));
         var height = parseInt(document.getElementById('banner').getAttribute('height'));
         var x = width  - parseInt(rectangle.getAttribute('x')) - 45;
         var y = height - parseInt(rectangle.getAttribute('height'));
         var legend = document.getElementById('legend');
         legend.style.top = y + "px"; legend.style.left = x + "px";
         legend.innerHTML=rectangle.id;
       } 
    ]]>
  </script>

</head>
<body>
<div id="legend">
Ustaw kursor myszy nad słupkiem, by poznać kategorię
</div>
<svg:svg baseProfile="full" version="1.1" width="100%" height="1600" >
<svg:defs>
    <svg:linearGradient id="gradient">
      <svg:stop stop-color='rgb(255,0,0)' offset='0%'/>
      <svg:stop stop-color='rgb(255,127,127)' offset='40%' />
      <svg:stop stop-color='rgb(127,0,0)'  offset='100%'/>
    </svg:linearGradient>
    <svg:linearGradient id="gradient2" x1="0%" y1="0%" x2="100%" y2="100%">
      <svg:stop stop-color='rgb(0,255,0)' offset='0%' />
      <svg:stop stop-color='rgb(255,0,0)' offset='100%' />
    </svg:linearGradient>
</svg:defs>
<?php

$handle = fopen("categories2.csv", "r");
$maxxx = 0;
$maxy = 0;
while (($category = fgetcsv($handle,1000,',')) != FALSE) {
   $y =  $category[1];
   if ($y > $maxy) $maxy = $y;
   $maxx += 50;
}
print("<svg:rect id='banner' width='$maxx' height='$maxy' x='0' y='0'  fill='url(#gradient2)' stroke='black' style='z-index: -1' />");
print("<svg:g id='container' transform='translate($maxx $maxy) rotate(180)'>");

rewind($handle);

$x = 0;
$ctr = 0;
$maxy = 0;
while (($category = fgetcsv($handle,1000,',')) != FALSE) {
   $y =  $category[1];
   if ($y > $maxy) $maxy = $y;
   $legend = $category[0];
   print("<svg:a xlink:href='http://burningbird.net/category/$legend/'><svg:rect id='$legend' width='50' height='$y' 
         x='$x' y='0' style='fill:url(#gradient);' stroke='navy' /></svg:a>");
   $x += 50; 
   $ctr++;
}    
fclose($handle);
echo "</svg:g>";

?>
</svg:svg>
</body>
</html>
